/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: netXTransportdll.c $:

  Description:
    Main module and entrypoint of the netXTransport DLL

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2013-02-23  initial version

**************************************************************************************/

/****************************************************************************/
/*! \file netXTransportdll.c
    Main module and entrypoint of the netXTransport DLL                     */
/****************************************************************************/

#include <windows.h>
#include "netXTransport.h"

HANDLE g_hModule = NULL;

extern void netXTransportDeInitcifXAPI( void);
extern void netXTransportInitcifXAPI  ( void);

BOOL APIENTRY DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
  UNREFERENCED_PARAMETER( lpReserved);
  switch(dwReason)
  {
  case DLL_PROCESS_ATTACH:
    /* Store our module handle */
    g_hModule = (HMODULE)hModule;

    /* NETXTRANSPORT_CIFX_API_INIT enables automatic netXTransport Toolkit initialization */
    /* configured for cifX API interface (windows specific feature).                      */
#ifdef NETXTRANSPORT_CIFX_API_INIT
    netXTransportInitcifXAPI();
#endif
    break;

  case DLL_PROCESS_DETACH:
#ifdef NETXTRANSPORT_CIFX_API_INIT
    netXTransportDeInitcifXAPI();
#endif
  break;

  case DLL_THREAD_ATTACH:
  case DLL_THREAD_DETACH:
    break;

  }

  return TRUE;
}
